/*
 * Copyright (c) 2016, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
 
/**
 * \file    camera.h
 *
 * \brief   camera Header File
 *
 * This header file contains the Macros definitions and Function declarations 
 * for camera application
 *
 * \author  Akhil Kumar
 *
 * \version 01,06 0ct 2016 Created.
 */
/*========================
 * Includes
 *========================
 */
 
#include "Dm8127_Platform.h"
/* ------------------------------------------------------------------------ *
 *  Prototypes                                                              *
 * ------------------------------------------------------------------------ */
 
 
/***
 * \brief: Camera module handler function.
 *
 * \b \Descr: This routine configure the camera module.
 *
 * \param: testArgs Arguments pointer
 *
 * \return: STATUS   SUCCESS on success
 * \n                FAILED  on failure
 */

STATUS camera_test
(
	void *testArgs
);
/***
 * \brief: routine to configuartion camera i2c.
 *
 *\b \descr: This routine configure the LVDS and the ar0331.
 *
 * \param: void pointer for future use
 *
 * \return:   SUCCESS on successful initialization.
 * \n         FAILED  failed to initialize.
 */
STATUS camera_i2c_configuration
(
	void *testArgs
);


/***
 * \brief: Routine to configure lvds control registers via i2c-2
 *
 * \b \Descr: This routine configure the bridge chip(i.e lvds) interfacing
 * \n         between sensor and controller.
 *
 * \param: VOID
 *
 * \return: SUCCESS on success
 * \n       FAILED  if any error
 */

 STATUS lvds_configuration
 (
 	void
 );
 /***
  * \brief: Routine to configure aptina AR0031 Sensor registers via i2c-2
  *
  * \b \Descr: This routine configure the AR0031 Sensor Register
  *
  * \param: VOID
  *
  * \return: SUCCESS on success
  * \n       FAILED if any error
  */

 STATUS ar0331_configuration
 (
 	void
 );
 /***
  * \brief: Routine to read aptina AR0031 Sensor registers via i2c-2
  *
  * \b Descr: This routine read the AR0031 Sensor Register data
  *
  * \param: reg_addr [IN] I2c camera write address
  * \       reg_val  [IN] reference variable
  *
  * \return:  SUCCESS on success
  * \n        FAILED if any error
  */

 STATUS ar0331_readRegister
 (
 	UINT16 reg_addr,
 	UINT16 reg_val
 );

 /***
  * \brief: Routine to reset aptina AR0031 Sensor by gpio pin toggling
  *
  * \b Descr: This routine reset the AR0031 Sensor
  *
  * \param: VOID
  * \return VOID
  */

 void camera_reset_toggle
 (
 	void
 );
 
 
 
